/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;

public class Theme {
    public static final Theme GLOW_THEME = new Theme();
    public static final Theme FLAT_COLOR = new Theme();
    public static final Theme SQUARE_THEME = new Theme();
    public static Theme currentTheme = GLOW_THEME;
    public static int iThemeNumber = 0;
    int srcBlendFactor = 770;
    int dstBlendFactor = 1;
    Color color = Color.white;
    public float[] clearColor = new float[4];
    static ArrayList<float[]> clearList = new ArrayList();
    private static int clearListNum = 0;
    public static boolean bUseBlending = true;
    static ArrayList<Theme> themeList = new ArrayList();

    public Theme() {
        this.color = Color.white;
        this.clearColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static void initialize() {
        Theme.GLOW_THEME.srcBlendFactor = 770;
        Theme.GLOW_THEME.dstBlendFactor = 1;
        Theme.GLOW_THEME.color = Color.white;
        Theme.GLOW_THEME.clearColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        Theme.FLAT_COLOR.srcBlendFactor = 770;
        Theme.FLAT_COLOR.dstBlendFactor = 768;
        Theme.FLAT_COLOR.color = Color.white;
        Theme.FLAT_COLOR.clearColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        Theme.SQUARE_THEME.srcBlendFactor = 770;
        Theme.SQUARE_THEME.dstBlendFactor = 1;
        Theme.SQUARE_THEME.color = Color.white;
        Theme.SQUARE_THEME.clearColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float fColorOffset = 0.2f;
        clearList.add(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        clearList.add(new float[]{fColorOffset, fColorOffset, fColorOffset, 1.0f});
        clearList.add(new float[]{fColorOffset, 0.0f, 0.0f, 1.0f});
        clearList.add(new float[]{fColorOffset, fColorOffset, 0.0f, 1.0f});
        clearList.add(new float[]{0.0f, fColorOffset, 0.0f, 1.0f});
        clearList.add(new float[]{0.0f, 0.0f, fColorOffset, 1.0f});
        themeList.add(GLOW_THEME);
        themeList.add(SQUARE_THEME);
    }

    public static void useNextTheme() {
        ++iThemeNumber;
        currentTheme = themeList.get(iThemeNumber %= themeList.size());
        clearListNum = 0;
    }

    public static void nextClearColor() {
        if (++clearListNum >= clearList.size()) {
            clearListNum = 0;
        }
        Theme.currentTheme.clearColor = clearList.get(clearListNum);
    }

    public static void useThemeBlendingFunction() {
        if (bUseBlending) {
            GL11.glBlendFunc(Theme.currentTheme.srcBlendFactor, Theme.currentTheme.dstBlendFactor);
        }
    }

    public static Color getThemeTextColor() {
        return Theme.currentTheme.color;
    }

    public static void setClearColor() {
        GL11.glClearColor(Theme.currentTheme.clearColor[0], Theme.currentTheme.clearColor[1], Theme.currentTheme.clearColor[2], Theme.currentTheme.clearColor[3]);
    }

    public static float convertToThemeAlpha(float fInputAlpha) {
        if (currentTheme == GLOW_THEME) {
            return fInputAlpha;
        }
        if (currentTheme == FLAT_COLOR || currentTheme == SQUARE_THEME) {
            return 1.0f;
        }
        return fInputAlpha;
    }
}

